require 'redmine'

Redmine::Plugin.register :redmine_involvement_filter do
  name 'Redmine Issue Involvement Filter plugin modded'
  author 'Alex Shulgin <ash@commandprompt.com>'
  description 'A plugin to filter out issues in which the current user is involved. This copy is modded by LTT Quan to use Or operator in filter, required manual patch in models/querry.rb::statement'
  version '0.2.0'
#  url 'http://example.com/path/to/plugin'
#  author_url 'http://example.com/about'
end

prepare_block = Proc.new do
  Query.send(:include, RedmineInvolvementFilter::QueryPatch)
end

if Rails.env.development?
  ActionDispatch::Reloader.to_prepare { prepare_block.call }
else
  prepare_block.call
end
